//
//  TortoiseAndHare.swift
//  AnimationAndGraph
//
//  Created by 朱克剛 on 2022/8/28.
//

import SwiftUI

struct TortoiseAndHare: View {
    @State private var tortoiseSpeed = 0.0
    @State private var hareSpeed = 0.0
    
    var body: some View {
        HStack(alignment: .top) {
            Button("Go") {
                withAnimation(.easeOut(duration: 2)) {
                    tortoiseSpeed = 150
                    hareSpeed = 200
                }
            }
            .buttonStyle(.bordered)
            
            VStack {
                // 烏龜圖案
                Image(systemName: "tortoise")
                    .offset(x: tortoiseSpeed)
                // 兔子圖案
                Image(systemName: "hare")
                    .offset(x: hareSpeed)
                
            }
            Spacer()
        }
        .frame(width: 300)
    }
}

struct TortoiseAndHare_Previews: PreviewProvider {
    static var previews: some View {
        TortoiseAndHare()
    }
}
