//
//  Trim.swift
//  AnimationAndGraph
//
//  Created by 朱克剛 on 2022/8/29.
//

import SwiftUI

struct Trim: View {
    @State private var value = 1.0
    var body: some View {
        VStack {
            Slider(value: $value)
                .frame(width: 200)
            Text(value, format: .number)
            
            Path { path in
                path.move(to: .init(x: 50, y: 50))
                path.addLine(to: .init(x: 200, y: 50))
                path.addLine(to: .init(x: 200, y: 300))
                path.addLine(to: .init(x: 50, y: 300))
                path.closeSubpath()
            }
            .trim(to: value)
            .stroke(lineWidth: 10)
        }
    }
}

struct Trim_Previews: PreviewProvider {
    static var previews: some View {
        Trim()
    }
}
