//
//  Animation.swift
//  MapsDemo
//
//  Created by 朱克剛 on 2022/8/29.
//

import SwiftUI
import MapKit

struct Animation: View {
    struct AnnotationItem: Identifiable {
        let id = UUID()
        var region: MKCoordinateRegion
    }
    @State var annotations: [AnnotationItem] = []
    
    private func getRegion() -> MKCoordinateRegion {
        if annotations.isEmpty {
            return MKCoordinateRegion(.world)
        } else {
            return annotations.first!.region
        }
    }
    
    private func setAnnotation(latitude: Double, longitude: Double) {
        let region = MKCoordinateRegion(
            center: CLLocationCoordinate2D(
                latitude: latitude,
                longitude: longitude
            ),
            latitudinalMeters: 500,
            longitudinalMeters: 500
        )
       
        annotations.removeAll(keepingCapacity: true)
        annotations.append(AnnotationItem(region: region))
    }
    
    var body: some View {
        VStack {
            HStack {
                Button("台北101") {
                    setAnnotation(latitude: 25.0342, longitude: 121.5646)
                }
                
                Button("高雄85大樓") {
                    setAnnotation(latitude: 22.6119, longitude: 120.3003)
                }
                
                Button("清除標記") {
                    annotations.removeAll(keepingCapacity: true)
                }
            }
            .buttonStyle(.bordered)
            
            Map(coordinateRegion: .constant(getRegion()), annotationItems: annotations) { annotation in
                MapMarker(coordinate: annotation.region.center)
            }
            .animation(.default, value: annotations.first?.id)
        }
    }
}

struct Animation_Previews: PreviewProvider {
    static var previews: some View {
        Animation()
    }
}
