//
//  Callout.swift
//  MapsDemo
//
//  Created by 朱克剛 on 2022/8/30.
//

import SwiftUI

struct Callout: View {
    var annotation: TapAnnotation.AnnotationItem
    var body: some View {
        HStack {
            Text(annotation.title)
                .font(.callout)
                .allowsHitTesting(false)
        }
        .frame(width: 100, height: 36)
        .background(.white)
        .cornerRadius(4)
        .shadow(radius: 10, x: 5, y: 5)
        .offset(y: -40)
    }
}

struct Callout_Previews: PreviewProvider {
    static var previews: some View {
        Callout(annotation: .init("測試", latitude: 0, longitude: 0))
    }
}
