//
//  CustomAnnotation.swift
//  MapsDemo
//
//  Created by 朱克剛 on 2022/8/29.
//

import SwiftUI
import MapKit

struct CustomAnnotation: View {
    // 台灣地理中心碑經緯度
    @State var region = MKCoordinateRegion(
        center: CLLocationCoordinate2D(
            latitude: 23.9742,
            longitude: 120.9797
        ),
        latitudinalMeters: 300_000,
        longitudinalMeters: 300_000
    )
    
    struct AnnotationItem: Identifiable {
        let id = UUID()
        var title: String
        var coordinate: CLLocationCoordinate2D
        
        init(_ title: String, latitude: Double, longitude: Double) {
            self.title = title
            coordinate = CLLocationCoordinate2D(
                latitude: latitude,
                longitude: longitude
            )
        }
    }

    let annotations: [AnnotationItem] = [
        .init("台北101", latitude: 25.0342, longitude: 121.5646),
        .init("高雄85大樓", latitude: 22.6119, longitude: 120.3003)
    ]

    var body: some View {
        Map(coordinateRegion: $region, annotationItems: annotations) { annotation in
            MapAnnotation(coordinate: annotation.coordinate) {
                VStack(spacing: 5) {
                    Image(systemName: "pin.fill")
                        .imageScale(.large)
                        .foregroundColor(.red)
                        .rotationEffect(Angle(degrees: 30))
                    
                    Text(annotation.title)
                        .font(.headline)
                }
            }
        }
    }
}

struct CustomAnnotation_Previews: PreviewProvider {
    static var previews: some View {
        CustomAnnotation()
    }
}
