//
//  Region.swift
//  MapsDemo
//
//  Created by 朱克剛 on 2022/8/29.
//

import SwiftUI
import MapKit

struct Region: View {
    @State var region = MKCoordinateRegion(
        center: CLLocationCoordinate2D(
            latitude: 25.0342,
            longitude: 121.5646
        ),
        latitudinalMeters: 1000,
        longitudinalMeters: 1000
    )

    var body: some View {
        Map(coordinateRegion: $region)
    }
}

struct Region_Previews: PreviewProvider {
    static var previews: some View {
        Region()
    }
}
