//
//  UserLocation.swift
//  MapsDemo
//
//  Created by 朱克剛 on 2022/8/29.
//

import SwiftUI
import MapKit
import CoreLocation

struct UserLocation: View {
    private let lm = CLLocationManager()
    
    @State var region = MKCoordinateRegion(
        center: CLLocationCoordinate2D(
            latitude: 25.0342,
            longitude: 121.5646
        ),
        latitudinalMeters: 1000,
        longitudinalMeters: 1000
    )
    
    init() {
        lm.requestAlwaysAuthorization()
        lm.requestWhenInUseAuthorization()
    }
    
    var body: some View {
        Map(coordinateRegion: $region,
            showsUserLocation: true,
            userTrackingMode: .constant(.follow)
        )
    }
}

struct UserLocation_Previews: PreviewProvider {
    static var previews: some View {
        UserLocation()
    }
}
