//
//  InRangeSelect.swift
//  DateDemo
//
//  Created by 朱克剛 on 2022/8/30.
//

import SwiftUI

struct InRangeSelect: View {
    @State private var date: Date = .now
    private var bounds: ClosedRange<Date> {
        Date.now ... Calendar.current.date(
            byAdding: .weekOfMonth,
            value: 2,
            to: Date.now)!
    }

    var body: some View {
        Form {
            DatePicker(
                "出發日期",
                selection: $date,
                in: bounds
            )
        }
    }
}

struct InRangeSelect_Previews: PreviewProvider {
    static var previews: some View {
        InRangeSelect()
    }
}
