//
//  MultiSelect.swift
//  DateDemo
//
//  Created by 朱克剛 on 2022/8/30.
//

import SwiftUI

struct MultiSelect: View {
    @State private var dates: Set<DateComponents> = []
    var body: some View {
        Form {
            MultiDatePicker("可選日期", selection: $dates)
            Button("選了哪些日子") {
                dates.forEach { component in
                    let date = Calendar.current.date(from: component)!
                    print(date)
                }
            }
        }
    }
}

struct MultiSelect_Previews: PreviewProvider {
    static var previews: some View {
        MultiSelect()
    }
}
