//
//  ManualPublishedTimer.swift
//  TimerDemo
//
//  Created by 朱克剛 on 2022/9/7.
//

import SwiftUI
import Combine

struct ManualPublishedTimer: View {
    @State private var n = 0
    @State private var cancel: Cancellable?
    @State var timer = Timer.TimerPublisher(
        interval: 1, runLoop: .current, mode: .default
    )
    
var body: some View {
    VStack {
        Button("啟動") {
            if cancel == nil {
                timer = Timer.TimerPublisher(
                    interval: 1, runLoop: .current, mode: .default
                )
            }
            cancel = timer.connect()
        }
        Button("停止") {
            cancel?.cancel()
            cancel = nil
        }
        Text(n, format: .number)

    }
    .onDisappear {
        cancel?.cancel()
        cancel = nil
    }
    .onReceive(timer) { _ in
        n += 1
    }
}
}

struct ManualPublishedTimer_Previews: PreviewProvider {
    static var previews: some View {
        ManualPublishedTimer()
    }
}
