//
//  PublishedTimer.swift
//  TimerDemo
//
//  Created by 朱克剛 on 2022/9/7.
//

import SwiftUI

struct PublishedTimer: View {
    @State private var n = 0
    private let timer = Timer.publish(
        every: 1, on: .current, in: .default
    ).autoconnect()

    var body: some View {
        Text(n, format: .number)
            .onReceive(timer) { _ in
                n += 1
            }
    }
}

struct PublishedTimer_Previews: PreviewProvider {
    static var previews: some View {
        PublishedTimer()
    }
}
