//
//  SimpleTimer.swift
//  TimerDemo
//
//  Created by 朱克剛 on 2022/9/7.
//

import SwiftUI

struct SimpleTimer: View {
    @State private var n = 0
    @State private var timer: Timer?

    func initTimer() -> Timer {
        Timer.scheduledTimer(withTimeInterval: 1, repeats: true) { _ in
            n += 1
            print(n)
        }
    }
    
    var body: some View {
        VStack {
            Button("啟動") {
                if let timer, timer.isValid {
                    
                } else {
                    timer = initTimer()
                }
            }
            Button("停止") {
                timer?.invalidate()
            }
            Text(n, format: .number)
        }
        .onDisappear {
            timer?.invalidate()
        }
    }
}

struct SimpleTimer_Previews: PreviewProvider {
    static var previews: some View {
        SimpleTimer()
    }
}
