//
//  Drag.swift
//  GestureDemo
//
//  Created by 朱克剛 on 2022/8/30.
//

import SwiftUI

struct Drag: View {
    @State private var offset: CGSize = .zero
    @State private var totalOffset: CGSize = .zero

    private var drag: some Gesture {
        DragGesture()
            .onChanged { event in
                offset = CGSize(
                    width: totalOffset.width + event.translation.width,
                    height: totalOffset.height + event.translation.height
                )
            }
            .onEnded { event in
                totalOffset = CGSize(
                    width: totalOffset.width + event.translation.width,
                    height: totalOffset.height + event.translation.height
                )
            }
    }

    var body: some View {
        Image(systemName: "basketball")
            .resizable()
            .frame(width: 50, height: 50)
            .offset(offset)
            .gesture(drag)
    }
}

struct Drag_Previews: PreviewProvider {
    static var previews: some View {
        Drag()
    }
}
