//
//  Magnification.swift
//  GestureDemo
//
//  Created by 朱克剛 on 2022/8/30.
//

import SwiftUI

struct Magnification: View {
    @State private var scale = 1.0
    var body: some View {
        Image(systemName: "arrowshape.left")
            .resizable()
//            .frame(width: 100 * scale, height: 100 * scale)
            .frame(width: 100, height: 100)
            .scaleEffect(scale)
            .gesture(
                MagnificationGesture()
                    .onChanged({ scale in
                        self.scale = scale
                    })
            )
    }

}

struct Magnification_Previews: PreviewProvider {
    static var previews: some View {
        Magnification()
    }
}
