//
//  Rotation.swift
//  GestureDemo
//
//  Created by 朱克剛 on 2022/8/30.
//

import SwiftUI

struct Rotation: View {
    @State private var angle: Angle = .zero
    var body: some View {
        Image(systemName: "arrowshape.left")
            .resizable()
            .frame(width: 100, height: 100)
            .rotationEffect(angle)
            .gesture(
                RotationGesture()
                    .onChanged({ angle in
                        self.angle = angle
                    })
                
            )
    }
}

struct Rotation_Previews: PreviewProvider {
    static var previews: some View {
        Rotation()
    }
}
