//
//  Scratch.swift
//  GestureDemo
//
//  Created by 朱克剛 on 2022/8/30.
//

import SwiftUI

struct Scratch: View {
    @State private var scratch = [(CGPoint.zero, CGPoint.zero)]
    @State private var start: CGPoint = .zero

    private var drag: some Gesture {
        DragGesture()
            .onChanged { action in
                guard start != .zero else {
                    start = action.startLocation
                    return
                }
                scratch.append((start, action.location))
                start = action.location
            }
        
            .onEnded { action in
                start = .zero
            }
    }

    var body: some View {
        Color.white
            .overlay {
                Path { path in
                    scratch.forEach { (start, end) in
                        path.move(to: start)
                        path.addLine(to: end)
                    }
                }
                .stroke(Color.blue, lineWidth: 3)
            }
            .gesture(drag)
    }
}

struct Scratch_Previews: PreviewProvider {
    static var previews: some View {
        Scratch()
    }
}
