//
//  TapGesture.swift
//  GestureDemo
//
//  Created by 朱克剛 on 2022/8/30.
//

import SwiftUI

struct TapGesture: View {
    @State private var point = CGPoint(x: Int.min, y: Int.min)
    var body: some View {
        Color.white
            .onTapGesture { point in
                self.point = point
            }
            .overlay {
                VStack {
                    Text(point.debugDescription)
                    Image(systemName: "sun.max")
                }
                .position(point)
            }
    }
}

struct TapGesture_Previews: PreviewProvider {
    static var previews: some View {
        TapGesture()
    }
}
