//
//  ContentView.swift
//  AppleIDDemo
//
//  Created by 朱克剛 on 2022/9/1.
//

import SwiftUI
import AuthenticationServices

struct ContentView: View {
    var body: some View {
        SignInWithAppleButton { request in
            request.requestedScopes = [.email, .fullName]
        } onCompletion: { result in
            switch result {
            case .success(let authorization):
                // 成功的程式碼寫這
                if let cred = authorization.credential as? ASAuthorizationAppleIDCredential {
                    // 將這些資料儲存在自己的資料庫中，尤其是 userIdentifier
                    let userIdentifier = cred.user
                    let fullName = cred.fullName
                    let email = cred.email
                    print((userIdentifier, fullName, email))
                }
                
            case .failure(let error):
                // 失敗的程式碼寫這
                print(error.localizedDescription)
            }
        }
        .frame(width: 200, height: 40)
        .signInWithAppleButtonStyle(.whiteOutline)
        
    }
}

struct ContentView_Previews: PreviewProvider {
    static var previews: some View {
        ContentView()
    }
}
