//
//  MapViewController.swift
//  LoadUIKit
//
//  Created by 朱克剛 on 2022/8/31.
//

import UIKit
import MapKit

class MapViewController: UIViewController, MKMapViewDelegate {
    @IBOutlet weak var map: MKMapView!
    
    override func viewDidLoad() {
        super.viewDidLoad()
        
        map.delegate = self
        map.register(
            MKAnnotationView.self,
            forAnnotationViewWithReuseIdentifier: "pin"
        )
        
        // 以臺灣地理中心為中心，東南西北各350公里的範圍
        let center = CLLocationCoordinate2D(
            latitude: 23.9742,
            longitude: 120.9797
        )
        let region = MKCoordinateRegion(
            center: center,
            latitudinalMeters: 350_000,
            longitudinalMeters: 350_000
        )
        map.setRegion(region, animated: false)
    }
    
    func mapView(_ mapView: MKMapView, viewFor annotation: MKAnnotation) -> MKAnnotationView? {
        let markView = mapView.dequeueReusableAnnotationView(
            withIdentifier: "pin", for: annotation)
        
        markView.image = UIImage(systemName: "house.fill")
        markView.canShowCallout = true
        return markView
    }

    @IBAction func fortSantoDomingo(_ sender: Any) {
        let annotation = MKPointAnnotation()
        annotation.coordinate = CLLocationCoordinate2D(
            latitude: 25.17562, longitude: 121.43302)
        annotation.title = "淡水紅毛城"
        map.addAnnotation(annotation)
    }
    
    /*
    // MARK: - Navigation

    // In a storyboard-based application, you will often want to do a little preparation before navigation
    override func prepare(for segue: UIStoryboardSegue, sender: Any?) {
        // Get the new view controller using segue.destination.
        // Pass the selected object to the new view controller.
    }
    */

}
