//
//  TakePhoto.swift
//  LoadUIKit
//
//  Created by 朱克剛 on 2022/8/31.
//

import SwiftUI

class MyDelegate: NSObject, UINavigationControllerDelegate, UIImagePickerControllerDelegate {
    private var complete: (UIImage) -> Void
    init(complete: @escaping (UIImage) -> Void) {
        self.complete = complete
    }
    
    func imagePickerController(_ picker: UIImagePickerController, didFinishPickingMediaWithInfo info: [UIImagePickerController.InfoKey : Any]) {
        if let image = info[.originalImage] as? UIImage {
            // 存檔
            UIImageWriteToSavedPhotosAlbum(image, nil, nil, nil)
            complete(image)
        }
        picker.dismiss(animated: true)
    }
}

struct CameraView: UIViewControllerRepresentable {
    @Binding var image: UIImage?
    
    func makeUIViewController(context: Context) -> UIImagePickerController {
        UIImagePickerController()
    }
    
    func updateUIViewController(_ uiViewController: UIImagePickerController, context: Context) {
        uiViewController.sourceType = .camera
        uiViewController.delegate = context.coordinator
    }
    
    func makeCoordinator() -> MyDelegate {
        MyDelegate { image in
            self.image = image
        }
    }
    
    typealias UIViewControllerType = UIImagePickerController
}

struct TakePhoto: View {
    @State private var isOpened = false
    @State private var image: UIImage?
    var body: some View {
        VStack {
            Button("拍照") {
                isOpened = true
            }
            
            if let image {
                Image(uiImage: image)
                    .resizable()
                    .frame(width: 200, height: 300)
                    .scaledToFit()
                    .clipped()
            }
        }
        .fullScreenCover(isPresented: $isOpened) {
            CameraView(image: $image)
        }
    }
}

struct TakePhoto_Previews: PreviewProvider {
    static var previews: some View {
        TakePhoto()
    }
}
