//
//  UKAVPlayer.swift
//  LoadUIKit
//
//  Created by 朱克剛 on 2022/8/31.
//

import SwiftUI
import AVKit

struct AVPlayerView: UIViewControllerRepresentable {
    var url: URL
    
    init(url: URL, pipMode: Bool=false) {
        self.url = url
        if pipMode {
            try! AVAudioSession.sharedInstance()
                    .setCategory(.playback)
        }
    }

    func makeUIViewController(context: Context) -> AVPlayerViewController {
        AVPlayerViewController()
    }
    
    func updateUIViewController(_ uiViewController: AVPlayerViewController, context: Context) {
        uiViewController.player = AVPlayer(url: url)
    }
    
    typealias UIViewControllerType = AVPlayerViewController
}

struct UKAVPlayer: View {
    @State private var url = URL(string: "https://file-examples.com/storage/fe2333f3be630e8e7965da7/2018/04/file_example_MOV_1280_1_4MB.mov")
    var body: some View {
        AVPlayerView(url: url!, pipMode: true)
    }
}

struct UKAVPlayer_Previews: PreviewProvider {
    static var previews: some View {
        UKAVPlayer()
    }
}
