//
//  UKWeb.swift
//  LoadUIKit
//
//  Created by 朱克剛 on 2022/8/31.
//

import SwiftUI
import WebKit

struct WebView: UIViewRepresentable {
    var url: URL
    func makeUIView(context: Context) -> WKWebView {
        WKWebView()
    }
    
    func updateUIView(_ uiView: WKWebView, context: Context) {
        uiView.load(URLRequest(url: url))
    }
    
    typealias UIViewType = WKWebView
}

struct UKWeb: View {
    @State private var url = URL(string: "https://www.apple.com")
    var body: some View {
        VStack {
            Button("CNN新聞") {
                url = URL(string: "https://cnn.com")
            }
            WebView(url: url!)
        }
    }
}

struct UKWeb_Previews: PreviewProvider {
    static var previews: some View {
        UKWeb()
    }
}
