//
//  BarcodeView.swift
//  AVCaptureDemo
//
//  Created by 朱克剛 on 2022/9/11.
//

import SwiftUI

class ImageData: ObservableObject {
    static let shared = ImageData()
    @Published var ciImage: CIImage?
}

//struct ImageView: UIViewRepresentable {
//    @StateObject private var imageData = ImageData.shared
//
//    func makeUIView(context: Context) -> UIImageView {
//        UIImageView()
//    }
//
//    func updateUIView(_ uiView: UIImageView, context: Context) {
//        guard let ciImage = imageData.ciImage else {
//            return
//        }
//        uiView.image = UIImage(ciImage: ciImage)
//    }
//
//    typealias UIViewType = UIImageView
//}
struct MyImageView: UIViewRepresentable {
    var ciImage: CIImage?
    
    func makeUIView(context: Context) -> UIImageView {
        UIImageView()
    }
    
    func updateUIView(_ uiView: UIImageView, context: Context) {
        guard let ciImage = ciImage else {
            return
        }
        uiView.image = UIImage(ciImage: ciImage, scale: 4, orientation: .up)
    }
    
    typealias UIViewType = UIImageView
}

struct BarcodeView: View {
    @State private var text = ""
    @State private var ciImage: CIImage?
    
    var body: some View {
        VStack {
            TextField("input data", text: $text)
            HStack {
                Button("Barcode") {
                    ciImage = genBarcode(content: text)
                }
                Button("QRCode") {
                    ciImage = genQRcode(content: text)
                }
            }
            MyImageView(ciImage: ciImage)
            .frame(width: 200, height: 200)
        }
    }
    
    // 一維碼
    func genBarcode(content: String) -> CIImage? {
        // 條碼內容
        let data = content.data(using: .ascii)
        // 條碼格式：Barcode
        let filter = CIFilter(name: "CICode128BarcodeGenerator")!
        filter.setValue(data, forKey: "inputMessage")
        // 產生條碼
        let transform = CGAffineTransform(scaleX: 10, y: 10)
        return filter.outputImage?.transformed(by: transform)
    }

    // QRCode
    func genQRcode(content: String) -> CIImage? {
        // 條碼內容
        let data = content.data(using: .utf8)
        // 條碼格式：QRCode
        let filter = CIFilter(name: "CIQRCodeGenerator")!
        filter.setValue(data, forKey: "inputMessage")
        // 產生條碼
        let transform = CGAffineTransform(scaleX: 10, y: 10)
        return filter.outputImage?.transformed(by: transform)
    }
}

struct BarcodeView_Previews: PreviewProvider {
    static var previews: some View {
        BarcodeView()
    }
}
