//
//  MetaRecognition.swift
//  AVCaptureDemo
//
//  Created by 朱克剛 on 2022/9/11.
//

import SwiftUI

struct BarcodeResultView: View {
    @StateObject var result = MetadataManager.current.barcoardResult
    var body: some View {
        VStack {
            Text("條碼類型：\(result.data.type)")
            Text("條碼內容：\(result.data.value)")
        }
    }
}

struct MetaRecognition: View {
    private let layer = MetadataManager.current.getPreviewLayer()
    var body: some View {
        VStack {
            Button("開始辨識") {
                MetadataManager.current.barcoardResult.data = ("", "")
                DispatchQueue.global().async {
                    MetadataManager.current.session.startRunning()
                }
            }
            
            GeometryReader { proxy in
                PreviewView(
                    previewLayer: layer, 
                    proxy: proxy
                ).background(.blue.opacity(0.1))
            }
            .frame(width: 300, height: 300)
            BarcodeResultView()
        }
    }
}

struct MetaRecognition_Previews: PreviewProvider {
    static var previews: some View {
        MetaRecognition()
    }
}
