//
//  TakePhoto.swift
//  AVCaptureDemo
//
//  Created by 朱克剛 on 2022/9/10.
//

import SwiftUI

struct TakePhoto: View {
    private let layer = CameraManager.current.getPreviewLayer()
    @State private var isFront = true
    var body: some View {
        VStack {
            HStack {
                Button("開始預覽") {
                    DispatchQueue.global().async {
                        CameraManager.current.session.startRunning()
                    }
                }
                Button("拍照") {
                    CameraManager.current.takePicture()
                }
                Toggle(isOn: $isFront) {
                    
                }
                .onChange(of: isFront) { newValue in
                    CameraManager.current.toggleCamera(isFront: isFront)
                }
            }
            .frame(width: 200)
            
            GeometryReader { proxy in
                PreviewView(
                    previewLayer: layer,
                    proxy: proxy
                ).background(.blue.opacity(0.1))
            }
            .frame(width: 200, height: 200)
        }
    }
}

struct TakePhoto_Previews: PreviewProvider {
    static var previews: some View {
        TakePhoto()
    }
}
