//
//  VideoCapture.swift
//  AVCaptureDemo
//
//  Created by 朱克剛 on 2022/9/10.
//

import SwiftUI

struct VideoCapture: View {
    private let layer = MovieManager.current.getPreviewLayer()
    var body: some View {
        VStack {
            HStack {
                Button("開始預覽") {
                    DispatchQueue.global().async {
                        MovieManager.current.session.startRunning()
                    }
                }
                Button("錄影開始") {
                    MovieManager.current.startRecording()
                }
                Button("錄影結束") {
                    MovieManager.current.stopRecording()
                }
            }
            .frame(width: 200)
            
            GeometryReader { proxy in
                PreviewView(
                    previewLayer: layer,
                    proxy: proxy
                ).background(.blue.opacity(0.1))
            }
            .frame(width: 200, height: 200)
        }
    }
}

struct VideoCapture_Previews: PreviewProvider {
    static var previews: some View {
        VideoCapture()
    }
}
