//
//  GPS.swift
//  Sensors
//
//  Created by 朱克剛 on 2022/9/1.
//

import SwiftUI
import CoreLocation

class LocationManager: NSObject, ObservableObject, CLLocationManagerDelegate {
    static let shared = LocationManager()
    private let lm = CLLocationManager()
    @Published var lastLocation: CLLocation?
    @Published var heading: CLHeading?
    
    override init() {
        super.init()
        lm.requestWhenInUseAuthorization()
        lm.requestAlwaysAuthorization()
        lm.delegate = self
        lm.startUpdatingLocation()
        lm.startUpdatingHeading()
    }

    func locationManager(_ manager: CLLocationManager, didUpdateLocations locations: [CLLocation]) {
        // 取得座標與高度資料
        guard let location = locations.last else {
            return
        }
        lastLocation = location
    }

    func locationManager(_ manager: CLLocationManager, didUpdateHeading newHeading: CLHeading) {
        // 取得面朝方向資料
        heading = newHeading
    }
}

struct GPS: View {
    @StateObject private var lm = LocationManager.shared
    var body: some View {
        List {
            Section("緯度") {
                Text("\(lm.lastLocation?.coordinate.latitude ?? 0)")
            }
            Section("經度") {
                Text("\(lm.lastLocation?.coordinate.longitude ?? 0)")
            }
            Section("高度") {
                Text("\(lm.lastLocation?.altitude ?? 0)")
            }
            Section("正北") {
                Text("\(lm.heading?.trueHeading ?? -1)")
            }
            Section("磁北") {
                Text("\(lm.heading?.magneticHeading ?? -1)")
            }
        }
    }
}

struct GPS_Previews: PreviewProvider {
    static var previews: some View {
        GPS()
    }
}
