//
//  MotionSensor.swift
//  Sensors
//
//  Created by 朱克剛 on 2022/9/1.
//

import SwiftUI
import CoreMotion

class MotionManager: NSObject, ObservableObject {
    static let shared = MotionManager()
    private let mm = CMMotionManager()
    // 加速儀
    @Published var acceleration: CMAcceleration?
    // 陀螺儀
    @Published var rotationRate: CMRotationRate?
    // 磁力儀
    @Published var magneticField: CMMagneticField?
    
    // 統整數據
    @Published var deviceMotion: CMDeviceMotion?
    
    // 加速儀
    func startAccelerometerUpdates() {
        mm.startAccelerometerUpdates(to: OperationQueue()) { data, error in
            DispatchQueue.main.async {
                self.acceleration = data?.acceleration
            }
        }
    }

    // 陀螺儀
    func startGyroUpdates() {
        mm.startGyroUpdates(to: OperationQueue()) { data, error in
            DispatchQueue.main.async {
                self.rotationRate = data?.rotationRate
            }
        }
    }

    // 磁力儀
    func startMagnetometerUpdates() {
        mm.startMagnetometerUpdates(to: OperationQueue()) { data, error in
            DispatchQueue.main.async {
                self.magneticField = data?.magneticField
            }
        }
    }
    
    // 裝置動作
    func startDeviceMotionUpdates() {
        mm.startDeviceMotionUpdates(using: .xTrueNorthZVertical, to: OperationQueue()) { data,  error in
            DispatchQueue.main.async {
                self.deviceMotion = data
            }
        }
    }
    
    func stop() {
        mm.stopAccelerometerUpdates()
        mm.stopGyroUpdates()
        mm.stopMagnetometerUpdates()
        mm.stopDeviceMotionUpdates()
    }

}

struct MotionSensor: View {
    @StateObject private var motionManager = MotionManager.shared
    // 陀螺儀
    private var gryo: CMRotationRate? {
        motionManager.rotationRate
    }
    // 裝置動作 - 重力
    private var gravity: CMAcceleration? {
        motionManager.deviceMotion?.gravity
    }
    
    var body: some View {
        VStack {
            HStack {
                Button("Start") {
                    motionManager.startGyroUpdates()
                    motionManager.startDeviceMotionUpdates()
                }
                Button("Stop") {
                    motionManager.stop()
                }
            }
            List {
                Section("陀螺儀") {
                    Text(gryo?.x ?? 0, format: .number)
                    Text(gryo?.y ?? 0, format: .number)
                    Text(gryo?.z ?? 0, format: .number)
                }
                
                Section("加速度（含重力加速度）") {
                    Text(gravity?.x ?? 0, format: .number)
                    Text(gravity?.y ?? 0, format: .number)
                    Text(gravity?.z ?? 0, format: .number)
                }
            }
            
        }
    }
}

struct MotionSensor_Previews: PreviewProvider {
    static var previews: some View {
        MotionSensor()
    }
}
