//
//  FileHandleDemo.swift
//  FileIO
//
//  Created by 朱克剛 on 2022/9/5.
//

import SwiftUI

struct FileHandleDemo: View {
    var body: some View {
        Button("Click") {
            let path = NSHomeDirectory() + "/Documents/file.txt"

            if !FileManager.default.fileExists(atPath: path) {
                FileManager.default.createFile(atPath: path, contents: nil)
            }
            
            if let f = FileHandle(forUpdatingAtPath: path) {
                do {
                    let data = "new data".data(using: .utf8)
                    try f.seekToEnd()
                    try f.write(contentsOf: data!)
                    try f.synchronize()
                    try f.close()
                } catch {
                    print(error.localizedDescription)
                }
            } else {
                print("file cannot open")
            }
        }
    }
}

struct FileHandleDemo_Previews: PreviewProvider {
    static var previews: some View {
        FileHandleDemo()
    }
}
