//
//  FileManagerDemo.swift
//  FileIO
//
//  Created by 朱克剛 on 2022/9/4.
//

import SwiftUI

struct FileManagerDemo: View {
    
    private func cd(_ path: String=NSHomeDirectory().appending("/Documents")) {
        FileManager.default.changeCurrentDirectoryPath(path)
    }
    
    var body: some View {
        List {
            Button("現行工作目錄") {
                let pwd = FileManager.default.currentDirectoryPath
                print(pwd)
            }
            Button("修改現行工作目錄") {
                cd()
                print(FileManager.default.currentDirectoryPath)
            }
            Button("建立目錄") {
                cd()
                try! FileManager.default.createDirectory(
                    atPath: "data",
                    withIntermediateDirectories: true
                )
            }
            Button("建立檔案") {
                cd()
                let ret = FileManager.default.createFile(
                    atPath: "file",
                    contents: nil
                )
            }
            Button("複製") {
                cd()
                let fm = FileManager.default
                try! fm.createDirectory(
                    atPath: "xcode/app/",
                    withIntermediateDirectories: true
                )
                let ret = fm.createFile(atPath: "xcode/app/file", contents: nil)
                try! fm.copyItem(
                    atPath: "xcode",
                    toPath: "xcode.backup"
                )
            }
            Button("搬移") {
                cd()
                FileManager.default.createFile(
                    atPath: "file",
                    contents: nil
                )
                try! FileManager.default.createDirectory(
                    atPath: "tmp",
                    withIntermediateDirectories: true
                )
                try! FileManager.default.moveItem(
                    atPath: "file",
                    toPath: "tmp/newfile"
                )
            }
            Button("刪除檔案") {
                cd()
                try! FileManager.default.removeItem(atPath: "tmp")
            }
            Button("檢查檔案是否存在") {
                let path = NSHomeDirectory() + "/Documents"
                if FileManager.default.fileExists(atPath: path) {
                    print("file exists")
                }
            }
        }
    }
}

struct FileManagerDemo_Previews: PreviewProvider {
    static var previews: some View {
        FileManagerDemo()
    }
}
