//
//  SaveAndLoad.swift
//  FileIO
//
//  Created by 朱克剛 on 2022/9/4.
//

import SwiftUI

struct SaveAndLoad: View {
    private let url = URL(filePath: NSHomeDirectory().appending("/Documents/file.txt"))
    @State private var text = ""
    var body: some View {
        VStack {
            HStack {
                Button("Save") {
                    try! text.write(to: url, atomically: true, encoding: .utf8)
                }
                Button("Load") {
                    text = try! String(contentsOf: url)
                }
                Button("Clear") {
                    text = ""
                }
            }
            .buttonStyle(.bordered)
            
            TextField("note", text: $text, axis: .vertical)
                .lineLimit(10, reservesSpace: true)
                .background(.green.opacity(0.1))
                .padding()
        }
        .onAppear {
            print(NSHomeDirectory())
        }
            
    }
}

struct SaveAndLoad_Previews: PreviewProvider {
    static var previews: some View {
        SaveAndLoad()
    }
}
