//
//  UserDefaultDemo.swift
//  FileIO
//
//  Created by 朱克剛 on 2022/9/4.
//

import SwiftUI

let KEY_USER_ID = "key_user_id"
let KEY_USER_EMAIL = "key_user_email"

struct UserDefaultDemo: View {
    var body: some View {
        VStack {
            Button("Save") {
                // 字串型態
                UserDefaults.standard.setValue("Hello, World!", forKey: "key1")
                // 數字型態
                UserDefaults.standard.setValue(3.1416, forKey: "key2")
                // 數字陣列
                UserDefaults.standard.setValue([1, 2, 3, 4], forKey: "key3")
                // 字典型態
                UserDefaults.standard.setValue(["name": "David"], forKey: "key4")
            }
            
            Button("Load") {
                let str = UserDefaults.standard.string(forKey: "key1")
                print(str)

                let value = UserDefaults.standard.double(forKey: "key2")
                print(value)

                let arr = UserDefaults.standard.array(forKey: "key3") as! [Int]
                print((arr[0], arr[1], arr[2]))

                let dict = UserDefaults.standard.dictionary(forKey: "key4") as! [String: String]
                print(dict["name"])
            }
        }
    }
}

struct UserDefaultDemo_Previews: PreviewProvider {
    static var previews: some View {
        UserDefaultDemo()
    }
}
