//
//  AsyncAwait.swift
//  GCDDemo
//
//  Created by 朱克剛 on 2022/9/6.
//

import SwiftUI

class NewMessage: ObservableObject {
    @Published var text = ""
}

struct AsyncAwait: View {
    @StateObject private var message = NewMessage()
    @State private var text = ""
    
    private func f() async {
        message.text = "Hello, World!"
    }

    var body: some View {
        VStack {
            Button("Click") {
                Task {
                    await f()
                }
                print("done")
            }
            Text(text)
                .onReceive(message.$text) { output in
                    text = output
                }
        }
    }
}

struct AsyncAwait_Previews: PreviewProvider {
    static var previews: some View {
        AsyncAwait()
    }
}
