//
//  MainQueue.swift
//  GCDDemo
//
//  Created by 朱克剛 on 2022/9/5.
//

import SwiftUI

class Message: ObservableObject {
    @Published var text: String = ""
}

struct MainQueue: View {
    @StateObject private var message = Message()
    private let aphorism = [
        "天生我材必有用。",
        "風聲雨聲讀書聲聲聲入耳，家事國事天下事事事關心。",
        "舊書不厭百回讀，熟讀深思子自知。",
        "天行健，君子以自強不息。"
    ]
    private var range: Range<Int> {
        0..<aphorism.count
    }
    
    var body: some View {
        Text(message.text)
            .onAppear {
                DispatchQueue.global().async {
                    while true {
                        DispatchQueue.main.sync {
                            message.text = aphorism[Int.random(in: range)]
                        }
                        sleep(1)
                    }
                }
            }
    }
}

struct MainQueue_Previews: PreviewProvider {
    static var previews: some View {
        MainQueue()
    }
}
