//
//  Semaphore.swift
//  GCDDemo
//
//  Created by 朱克剛 on 2022/9/6.
//

import SwiftUI

struct Semaphore: View {
    @State private var value = 10
    
    private func run() {
        guard value > 0 else {
            return
        }
        
        Thread.sleep(forTimeInterval: 0.001)
        value -= 1
    }
    
    var body: some View {
        VStack {
            Button("click") {
                value = 10
                for _ in Range(1...100) {
                    DispatchQueue.global(qos: .background).async {
                        run()
                    }
                }
            }
            Text(value, format: .number)
        }
    }
}

struct Semaphore_Previews: PreviewProvider {
    static var previews: some View {
        Semaphore()
    }
}
