//
//  Semaphore_Done.swift
//  GCDDemo
//
//  Created by 朱克剛 on 2022/9/6.
//

import SwiftUI

struct Semaphore_Done: View {
    @State private var value = 10
    
    private let semaphore = DispatchSemaphore(value: 1)
    private func run() {
        if semaphore.wait(timeout: .distantFuture) == .success {
            guard value > 0 else {
                semaphore.signal()
                return
            }
            Thread.sleep(forTimeInterval: 0.001)
            value -= 1
            semaphore.signal()
        }
    }
    
    var body: some View {
        VStack {
            Button("click") {
                value = 10
                for _ in Range(1...100) {
                    DispatchQueue.global(qos: .background).async {
                        run()
                    }
                }
            }
            Text(value, format: .number)
        }
    }
}

struct Semaphore_Done_Previews: PreviewProvider {
    static var previews: some View {
        Semaphore_Done()
    }
}
