//
//  SleepDemo.swift
//  GCDDemo
//
//  Created by 朱克剛 on 2022/10/4.
//

import SwiftUI

struct SleepDemo: View {
    var body: some View {
        VStack {
            Button("Thread Sleep") {
                DispatchQueue.global().async {
                    for i in 0...10 {
                        print(i)
                        Thread.sleep(forTimeInterval: 0.3)
                    }
                }
            }
            
            Button("Task Sleep") {
                Task {
                    for i in 0...10 {
                        print(i)
                        try await Task.sleep(nanoseconds: 300_000_000)
                    }
                }
            }
            
            Button("After") {
                DispatchQueue.global().asyncAfter(deadline: .now() + 3) {
                    print("Hello, World!")
                }
            }
        }
    }
}

struct SleepDemo_Previews: PreviewProvider {
    static var previews: some View {
        SleepDemo()
    }
}
