//
//  JSONParserDemo.swift
//  InternetDemo
//
//  Created by 朱克剛 on 2022/9/2.
//

import SwiftUI

struct Weather: Codable {
    var date: String
    var records: [Record]
    
    init(_ filename: String) {
        let url = Bundle.main.url(forResource: filename, withExtension: nil)
        let data = try! Data(contentsOf: url!)
        do {
            self = try JSONDecoder().decode(Weather.self, from: data)
        } catch {
            fatalError(error.localizedDescription)
        }
    }
}

struct Record: Codable, Identifiable {
    var id: UUID { UUID() }
    var city: String
    var temperature: Int
    var humidity: Int
    var tempF: Double {
        (Double(temperature) * 9 / 5 + 32).rounded()
    }
}

let weather = Weather("data.json")

struct JSONParserDemo: View {
    var body: some View {
        List {
            Section(weather.date) {
                ForEach(weather.records, id: \.city) { value in
                    HStack {
                        Text(value.city)
                        Text(value.temperature, format: .number)
                        Text(value.humidity, format: .percent)
                        Text(value.tempF, format: .number)
                    }
                }
            }
        }
    }
}

struct JSONParserDemo_Previews: PreviewProvider {
    static var previews: some View {
        JSONParserDemo()
    }
}
