//
//  SocketClientView.swift
//  InternetDemo
//
//  Created by 朱克剛 on 2022/9/3.
//

import SwiftUI

struct SocketClientView: View {
    @ObservedObject var client = SocketClient()
    @State private var host = "soniaipad.local"
    @State private var port = "8080"
    @State private var text = ""
    @State private var messages: [String] = []
    
    var body: some View {
        NavigationStack {
            TextField("message", text: $text)
                .textFieldStyle(.roundedBorder)
                .padding()
                .disabled(!client.isConnect)
                .onSubmit {
                    client.send(text.data(using: .utf8)!)
                }
            
            List(messages, id: \.self) { value in
                Text(value)
            }
            .onReceive(client.$receivedString) { output in
                if !output.isEmpty {
                    messages.append(output)
                }
            }
        }
        .toolbar {
            // 將連線按鈕放在導覽列右方
            Button {
                client.start(host: host, port: Int(port) ?? 0)
            } label: {
                Image(systemName: "personalhotspot")
            }
        }
    }
}

struct SocketClientView_Previews: PreviewProvider {
    static var previews: some View {
        SocketClientView()
    }
}
