//
//  URLSession_Demo.swift
//  InternetDemo
//
//  Created by 朱克剛 on 2022/9/9.
//

import SwiftUI

struct URLSession_Demo: View {
    let url = URL(string: "http://localhost:5000")!
    var body: some View {
        Button("RESTful Web API") {
            Task {
                var request = URLRequest(url: url)
                request.addValue("AAA", forHTTPHeaderField: "MyHeader1")
                request.setValue("BBB", forHTTPHeaderField: "MyHeader2")
                request.allHTTPHeaderFields = [
                    "MyHeader3": "CCC",
                    "MyHeader4": "DDD"
                ]
                
                request.httpMethod = "POST"
                let data = #"{"name": "David"}"#.data(using: .utf8)
                request.httpBody = data
                
                let _ = try await URLSession.shared.data(for: request)
            }
        }
    }
}

struct URLSession_Demo_Previews: PreviewProvider {
    static var previews: some View {
        URLSession_Demo()
    }
}
