//
//  URLSession_Publish.swift
//  InternetDemo
//
//  Created by 朱克剛 on 2022/9/4.
//

import SwiftUI
import Combine

struct URLSession_Publish: View {
    @State private var urlString = ""
    @State private var result = 0
    @State private var isProcessing = false
    @State private var cancellable: AnyCancellable?
    
    private func callAPI(with url: URL) {
        cancellable = URLSession.shared.dataTaskPublisher(for: url)
            .sink { value in
                switch value {
                case .finished:
                    // 執行完畢
                    isProcessing = false
                    break
                case .failure(let error):
                    isProcessing = false
                    print(error)
                }
            } receiveValue: { data, response in
                result = data.count
            }
    }
    
    var body: some View {
        Form {
            TextField("url", text: $urlString)
                .autocorrectionDisabled()
                .textInputAutocapitalization(.never)
                .onSubmit {
                    if let url = URL(string: urlString) {
                        isProcessing = true
                        callAPI(with: url)
                    }
                }
                .onChange(of: urlString) { _ in
                    result = 0
                }
            
            Text("此網址內容有 \(result.formatted(.number)) bytes")
        }
        .overlay {
            if isProcessing {
                ProgressView()
            }
        }
    }
}

struct URLSession_Publish_Previews: PreviewProvider {
    static var previews: some View {
        URLSession_Publish()
    }
}
