//
//  WebAPI.swift
//  InternetDemo
//
//  Created by 朱克剛 on 2022/9/2.
//

import SwiftUI
import Combine

struct WebAPI: View {
    let url = URL(string: "https://www.apple.com")!
    @State private var text = ""
    @State private var data = Data()
    @State var cancellable: AnyCancellable?
    var body: some View {
        List {
            Button("同步") {
                // 同步呼叫放按鈕中在 Xcode14 會得到錯誤訊息喔
                text = try! String(contentsOf: url)
                print(text)
            }
            
            Button("非同步+GCD") {
                DispatchQueue.global().async {
                    text = try! String(contentsOf: url)
                    print(text)
                }
            }
            
            Button("URLSession + Closure") {
                URLSession.shared.dataTask(with: url) { data, response, error in
                    guard let data else {
                        print(error.debugDescription)
                        return
                    }
                    text = String(data: data, encoding: .utf8)!
                    print(text)
                }.resume()
            }
            
            Button("URLSession + Async") {
                Task {
                    let (data, _) = try await URLSession.shared.data(from: url)
                    text = String(data: data, encoding: .utf8)!
                    print(text)
                }
            }
            
            Button("Combine") {
                cancellable = URLSession.shared.dataTaskPublisher(for: url)
                    .sink { value in
                        switch value {
                        case .finished:
                            // 執行完畢
                            break
                        case .failure(let error):
                            print(error)
                        }
                    } receiveValue: { data, response in
                        text = String(data: data, encoding: .utf8)!
                        print(text)
                    }
            }
        }
    }
}

struct WebAPI_Previews: PreviewProvider {
    static var previews: some View {
        WebAPI()
    }
}
