//
//  XMLParserDemo.swift
//  InternetDemo
//
//  Created by 朱克剛 on 2022/9/2.
//

import SwiftUI

class Node: Identifiable {
    var id = UUID()
    var elementName: String = ""
    var attributes: [String: String] = [:]
    var string: String = ""
    
    var children: [Node] = []
    var parent: Node?
}


class XMLToTree: NSObject, XMLParserDelegate {
    var tree: Node? = nil
    private var currentNode: Node? = nil
    
    init(_ filename: String) {
        super.init()
        let url = Bundle.main.url(forResource: filename, withExtension: nil)
        let parser = XMLParser(contentsOf: url!)
        parser?.delegate = self
        parser?.parse()
    }
    
    // 讀到開始標籤，例如<city>
    func parser(_ parser: XMLParser, didStartElement elementName: String, namespaceURI: String?, qualifiedName qName: String?, attributes attributeDict: [String : String] = [:]) {
        let newNode = Node()
        newNode.elementName = elementName
        newNode.attributes = attributeDict
        
        if tree == nil {
            newNode.parent = newNode
            currentNode = newNode
            tree = currentNode
        } else {
            currentNode?.children.append(newNode)
            newNode.parent = currentNode
            currentNode = newNode
        }
    }

    // 讀到開始標間與結束標籤間的內容，例如臺北市
    func parser(_ parser: XMLParser, foundCharacters string: String) {
        currentNode?.string = string
    }

    // 讀到結束標籤，例如</city>
    func parser(_ parser: XMLParser, didEndElement elementName: String, namespaceURI: String?, qualifiedName qName: String?) {
        currentNode = currentNode?.parent
    }
}


let tree = XMLToTree("data.xml").tree

struct XMLParserDemo: View {
    private func fetchRecords() -> [Node] {
        tree!.children.filter { node in
            node.elementName.lowercased() == "records"
        }
    }
    
    var body: some View {
        List {
            Section(tree!.children[0].string) {
                ForEach(fetchRecords()) { value in
                    HStack {
                        Text(value.children[0].string)
                        Text(value.children[1].string)
                        Text(value.children[2].string)
                    }
                }
            }
        }
    }
}

struct XMLParserDemo_Previews: PreviewProvider {
    static var previews: some View {
        XMLParserDemo()
    }
}
