//
//  ContentView.swift
//  PushNotificationDemo
//
//  Created by 朱克剛 on 2022/9/7.
//

import SwiftUI
import UserNotifications

struct ContentView: View {
    init() {
        Task {
            let opt: UNAuthorizationOptions = [
                .alert, .badge, .sound
            ]
            let center = UNUserNotificationCenter.current()
            if try! await center.requestAuthorization(options: opt) {
                // 使用者同意
            } else {
                // 使用者不同意
            }
        }
    }
    
    var body: some View {
        VStack {
            Image(systemName: "globe")
                .imageScale(.large)
                .foregroundColor(.accentColor)
            Text("Hello, world!")
        }
        .padding()
        .onAppear {
            let path = Bundle.main.path(forResource: "demo.aif", ofType: nil)
            print(path)
        }
    }
}

struct ContentView_Previews: PreviewProvider {
    static var previews: some View {
        ContentView()
    }
}
