//
//  LocalPush.swift
//  PushNotificationDemo
//
//  Created by 朱克剛 on 2022/9/7.
//

import SwiftUI
import CoreLocation

struct LocalPush: View {
    var body: some View {
        VStack {
            Button("Click") {
                // 推播內容
                let content = UNMutableNotificationContent()
                content.title = "推播測試"
                content.subtitle = Date.now.description
                content.badge = 10
                content.sound = .default
                content.body = "要推播的內容放這裡"
                
                // 觸發推播的條件，這裡設定時間，目前為10秒後推播
                let trigger = UNTimeIntervalNotificationTrigger(
                    timeInterval: 10, repeats: false
                )
                
                // 產生推播請求
                let request = UNNotificationRequest(
                    identifier: UUID().uuidString,
                    content: content,
                    trigger: trigger
                )
                
                // 將推播請求送交推播中心
                UNUserNotificationCenter.current().add(request)
            }
            
            Button("清除Badge") {
                UIApplication.shared.applicationIconBadgeNumber = 0
            }
        }
    }
}

struct LocalPush_Previews: PreviewProvider {
    static var previews: some View {
        LocalPush()
    }
}
