//
//  BeaconManager.swift
//  BLEBeacon
//
//  Created by 朱克剛 on 2022/9/13.
//

import Foundation
import CoreBluetooth
import CoreLocation

class BeaconManager: NSObject, CLLocationManagerDelegate {
    static let shared = BeaconManager()
    private let lm = CLLocationManager()
    
    override init() {
        super.init()
        lm.requestWhenInUseAuthorization()
        lm.requestAlwaysAuthorization()
        lm.delegate = self
    }
    
    func registerBeacons(with proximityUUIDs: [UUID], region name: String) {
        proximityUUIDs.forEach { uuid in
            let region = CLBeaconRegion(
                uuid: uuid,
                identifier: name
            )
            
            // 用來得知附近 beacon 的資訊。觸發1號method
            lm.startRangingBeacons(satisfying: region.beaconIdentityConstraint)
            // 用來接收進入區域或離開區域的通知。觸發2號與3號method
            lm.startMonitoring(for: region)
        }
    }
    
    // MARK: - 1號method
    func locationManager(_ manager: CLLocationManager, didRangeBeacons beacons:
    [CLBeacon], in region: CLBeaconRegion) {
        beacons.forEach { beacon in
            var distance: String = "unknow"
            switch beacon.proximity {
            case .far:
                distance = "far"
            
            case .near:
                distance = "near"

            case .immediate:
                distance = "immediate"
                
            case .unknown:
                print("unknown")

            @unknown default:
                break
            }
            
            // 印出beacon目前距離
            print((
                beacon.uuid.uuidString,
                beacon.major,
                beacon.minor,
                distance
            ))
        }
    }

    // MARK: - 2號method
    func locationManager(_ manager: CLLocationManager, didEnterRegion region:
    CLRegion) {
        print("進入 \(region.identifier) 範圍")
    }

    // MARK: 3號method
    func locationManager(_ manager: CLLocationManager, didExitRegion region:
    CLRegion) {
        print("離開 \(region.identifier) 範圍")
    }

}
