//
//  ContentView.swift
//  BLECentral
//
//  Created by 朱克剛 on 2022/9/12.
//

import SwiftUI

struct ContentView: View {
    @ObservedObject private var centralManager = CentralManager.shared
    @State private var messages: [String] = []
    var body: some View {
        VStack {
            HStack {
                Button("訂閱") {
                    centralManager.subscribe(for: .C001)
                }
                Button("取消") {
                    centralManager.unsubscribe(for: .C001)
                }
                Button("讀取") {
                    centralManager.read(for: .C001)
                }
                Button("解配對") {
                    centralManager.unpair()
                }
            }
            List(messages, id: \.self) { msg in
                Text(msg)
            }
            .onReceive(centralManager.$c001_reply_string) { output in
                if !output.isEmpty {
                    messages.append(output)
                }
            }
        }
    }
}

struct ContentView_Previews: PreviewProvider {
    static var previews: some View {
        ContentView()
    }
}
