//
//  ContentView.swift
//  FakeBeacon
//
//  Created by 朱克剛 on 2022/9/13.
//

import SwiftUI
import CoreBluetooth
import CoreLocation

class FakeBeacon: NSObject, CBPeripheralManagerDelegate {
    static let shared = FakeBeacon()
    private var peripheralManager: CBPeripheralManager?
    
    override init() {
        super.init()
        // 將觸發1號method
        peripheralManager = CBPeripheralManager(
            delegate: self,
            queue: .global()
        )
    }
    
    // MARK: 1號method
    func peripheralManagerDidUpdateState(_ peripheral: CBPeripheralManager) {
        guard peripheral.state == .poweredOn else {
            // 若藍牙沒開啟，作業系統會自動跳出提示
            return
        }
        
        let region = CLBeaconRegion(
            uuid: UUID(uuidString: "A86B9872-218E-47E2-B292-354AA46D9879")!,
            major: 100,
            minor: 20,
            identifier: "給個名字"
        )
        
        let op = region.peripheralData(
            withMeasuredPower: nil
        ) as! [String : Any]
        
        // 開始廣播訊號
        // 將觸發2號method
        peripheralManager?.startAdvertising(op)
    }

    // MARK: 2號method
    func peripheralManagerDidStartAdvertising(_ peripheral: CBPeripheralManager, error: Error?) {
        print("beacon 開始運作")
    }
}
    
struct ContentView: View {
    let beacon = FakeBeacon.shared
    var body: some View {
        VStack {
            Image(systemName: "globe")
                .imageScale(.large)
                .foregroundColor(.accentColor)
            Text("Hello, world!")
        }
        .padding()
    }
}

struct ContentView_Previews: PreviewProvider {
    static var previews: some View {
        ContentView()
    }
}
