//
//  BasicCRUD.swift
//  CoreDataDemo
//
//  Created by 朱克剛 on 2022/9/8.
//

import SwiftUI

struct BasicCRUD: View {
    @Environment(\.managedObjectContext) private var viewContext

    var body: some View {
        VStack {
            Button("Create") {
                var item = Item(context: viewContext)
                item.title = "早餐"
                item = Item(context: viewContext)
                item.title = "午餐"
                try! viewContext.save()
            }
            
            Button("Read") {
                let items = try! viewContext.fetch(Item.fetchRequest())
                items.forEach { item in
                    print(item.title)
                }
            }
            
            Button("Update") {
                var items = try! viewContext.fetch(Item.fetchRequest())
                let targetItem = items.first { item in
                    item.title == "早餐"
                }
                targetItem?.title = "早午餐"
                try! viewContext.save()
            }
            
            Button("Delete") {
                var items = try! viewContext.fetch(Item.fetchRequest())
                items.filter { item in
                    item.title == "午餐"
                }.forEach(viewContext.delete)
                try! viewContext.save()
            }
        }
    }
}

struct BasicCRUD_Previews: PreviewProvider {
    static var previews: some View {
        BasicCRUD()
    }
}
