//
//  DynamicReadData.swift
//  CoreDataDemo
//
//  Created by 朱克剛 on 2022/9/16.
//

import SwiftUI

struct DynamicReadData: View {
    @Environment(\.managedObjectContext) private var viewContext
    @FetchRequest(
        sortDescriptors: [SortDescriptor(\.price, order: .reverse)],
        animation: .default
    ) private var expenditures: FetchedResults<Expenditure>
    @State private var value = 0.0
    
    var body: some View {
        VStack {
            Slider(value: $value, in: 0...1000, step: 100)
                .onChange(of: value) { newValue in
                    expenditures.nsPredicate = NSPredicate(
                        format: "price > %f", value
                    )
                }
                .padding()
            List(expenditures) { value in
                Text(value.price, format: .number)
            }
        }
    }
}

struct DynamicReadData_Previews: PreviewProvider {
    static var previews: some View {
        DynamicReadData()
    }
}
